/*
 * @(#)SolutionPane.java  1.0  14. M�rz 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */
package ch.hslu.cm;

import java.awt.*;
import javax.swing.*;
import javax.swing.text.html.*;
import org.jhotdraw.util.ResourceBundleUtil;

/**
 * SolutionPane.
 *
 *
 * @author Werner Randelshofer
 * @version 1.0 14. M�rz 2006 Created.
 */
public class ComparisonPane extends javax.swing.JPanel {

    protected ResourceBundleUtil labels;

    /** Creates new form. */
    public ComparisonPane() {
        labels = ResourceBundleUtil.getBundle("ch.hslu.cm.Labels");
        initComponents();
        HTMLEditorKit editorKit = new HTMLEditorKit();
        textPane.setEditorKit(editorKit);
        textPane.putClientProperty("css.class", "comparison");
        putClientProperty("css.class", "comparisonPane");
        setOpaque(true);
        //setOpaque(false);
        // buttonPanel.setOpaque(false);
        // setBackground(new Color(UIManager.getColor("Panel.background").getRGB() & 0x80ffffff,true));
    }

    public void setStylesheet(StyleSheet stylesheet) {
        ((HTMLEditorKit) textPane.getEditorKit()).setStyleSheet(stylesheet);
        textPane.setDocument(textPane.getEditorKit().createDefaultDocument());
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(getBackground());
        g.fillRect(0, 0, getWidth(), getHeight());
        super.paint(g);
    }

    public void setText(String text) {
        textPane.setText(text);
    }

    public void scrollTextVisible() {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                textPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        // scrollPane.getViewport().setViewPosition(new Point(0,0));
    }

    public void close() {
        Container parent = getParent();
        if (parent != null) {
            parent.remove(this);
            //view.setDrawing(null);
            parent.repaint();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextPane1 = new javax.swing.JTextPane();
        buttonPanel = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();
        scrollPane = new javax.swing.JScrollPane();
        textPane = new javax.swing.JEditorPane();

        jScrollPane2.setViewportView(jTextPane1);

        setLayout(new java.awt.BorderLayout());

        setBorder(javax.swing.BorderFactory.createTitledBorder(labels.getString("comparisonWithSolution")));
        buttonPanel.setOpaque(false);
        closeButton.setText(labels.getString("close"));
        closeButton.setOpaque(false);
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                close(evt);
            }
        });

        buttonPanel.add(closeButton);

        add(buttonPanel, java.awt.BorderLayout.SOUTH);

        textPane.setEditable(false);
        scrollPane.setViewportView(textPane);

        add(scrollPane, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents

    private void close(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_close
        close();
    }//GEN-LAST:event_close
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton closeButton;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextPane jTextPane1;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JEditorPane textPane;
    // End of variables declaration//GEN-END:variables
}
